//Demonstrate the various Image Conversions
//Scilab 5.4.1
//Windows 10 
//Requires SIVP, IPD toolboxes

clear;
clc;

//RBG to Gray scale
baboon = imread('baboon.png');
babgray = rgb2gray(baboon);
imwrite(babgray,'babgray.jpeg');

//RBG to Binary
lena = imread('Lenna.png');
lenabw = im2bw(lena,0.5);
imwrite(lenabw,'lenabw.jpeg');

//RBG to HSV
cameraman = imread('cameraman.jpg');
cameramanhsv = rgb2hsv(cameraman);
imwrite(cameramanhsv,'cameramanhsv.jpeg');

//HSV to RGB
peppers = imread('peppers.png');
peppersrgb = hsv2rgb(peppers);
imwrite(peppersrgb,'peppersrgb.jpeg');

//RBG to YCbCr
baboon = imread('baboon.png');
baboonycbcr = rgb2ycbcr(baboon);
imwrite(baboonycbcr,'baboonycbcr.jpeg');

//YCbCr to RGB
ararauna = imread('ararauna.png');
araraunargb = ycbcr2rgb(ararauna);
imwrite(araraunargb,'araraunargb.jpeg');
